local assets=
{
	Asset("ANIM", "anim/warsaw545.zip"),
	Asset("ATLAS", "images/inventoryimages/warsaw545.xml"),
    Asset("IMAGE", "images/inventoryimages/warsaw545.tex"),
}

local prefabs =
{

}

local function OnHit(inst, owner, target)
    inst:Remove()    
end


local function fncommon(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	
	inst.AnimState:SetBank("warsaw545")
    inst.AnimState:SetBuild("warsaw545")
    inst.AnimState:PlayAnimation("idle", false)
    
    inst:AddTag("projectile")

				
    inst:AddComponent("stackable")	 
	inst.components.stackable.maxsize = 40
	
	inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(100)
	inst.components.projectile:SetOnHitFn(OnHit)
    inst.components.projectile:SetOnMissFn(OnHit)
	
    inst:AddComponent("inspectable")
    	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/warsaw545.xml"

	return inst
end



STRINGS.NAMES.WARSAW545 = "5.45x39mm."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.WARSAW545 = "Ammo for the abakan and akm."


return Prefab( "common/inventory/warsaw545", fncommon, assets)
